function mapApplication(lat, lng) {
    try {
        console.log('mapApplication.lat: ' + String(lat));
        console.log('mapApplication.lng: ' + String(lng));
        Android.mapApplication(lat, lng);
    } catch (error) {
        console.warn('mapApplication.error: ' + String(error));
    }
}
function getMobileOS() {
    return "iOS"
    // const ua = navigator.userAgent
    // if (/android/i.test(ua)) {
    //     return "Android"
    // }
    // else if ((/iPad|iPhone|iPod/.test(ua)) || (navigator.platform === 'MacIntel' && navigator.maxTouchPoints > 1)) {
    //     return "iOS"
    // }
    // return "Other"
}

function addBookmarks(divToAddTo) {
    let content = ""
    let bookmarksStr = window.localStorage.getItem('iosBookmarks');
    let bookmarks = [];
    if (bookmarksStr) {
        bookmarks = JSON.parse(bookmarksStr)
    }
    if (bookmarks.length > 0) {
        for (let i = 0; i < bookmarks.length; i++) {
            let item = bookmarks[i]
            content = content + "<div><a href='" + item.url + "'>" + item.title + "</a></div>"
        }
    }
    divToAddTo.innerHTML = content
}

function iosAddBookmarks(bookmark) {
    let bookmarksStr = window.localStorage.getItem('iosBookmarks');
    let bookmarks = [];
    if (bookmarksStr) {
        bookmarks = JSON.parse(bookmarksStr)
    }
    console.log(bookmarks)
    if (isBookmarkedIos(bookmark.url)) {
        console.log('YES IM BOOKMARKED ' + JSON.stringify(bookmark))
        bookmarks = bookmarks.filter(b => replaceMultipleSlashes(b.url) !== replaceMultipleSlashes(bookmark.url))
    } else {
        bookmarks.push(bookmark)
    }
    console.log('after ' + bookmarks)
    window.localStorage.setItem('iosBookmarks', JSON.stringify(bookmarks))
    console.log('bookmarks ', window.localStorage.getItem('iosBookmarks'));
    console.log('im here');
}

function bookmarkPage(title, url) {
    iosAddBookmarks({
        title,
        url
    });
}
// try {
//     console.log('bookmarkPage.title:' + title);
//     console.log('bookmarkPage.url:' + url);
//     Android.bookmarkPage(title, url);
// } catch (error) {
//     console.warn('bookmarkPage: Android not found, disabling feature...');
//     iosAddBookmarks({
//         title,
//         url
//     });
// }

function gotoFavourites() {
    let base = window.localStorage.getItem('baseUrl').split('guide')[0];
    let urlOut = base + "/guide/pages/iosBookmarks/index.html";
    console.log('urlOut ', urlOut)
    return urlOut
}
let bookmarks = [];
function initApp() {
    window.localStorage.setItem('baseUrl', window.location.pathname);
}
function isBookmarkedIos(url) {
    let bookmarksStr = window.localStorage.getItem('iosBookmarks');
    let bookmarks = [];
    if (bookmarksStr) {
        bookmarks = JSON.parse(bookmarksStr)
    }
    console.log('bookmarks are ', bookmarks)
    var test = bookmarks.find(b => replaceMultipleSlashes(b.url) === replaceMultipleSlashes(url));
    console.log('isBookmarked.result:' + test);
    if (test) {
        console.log('yes i have bookmark')
        return true;
    }
}


function selectBookmark() {
    try {
        console.log('selectBookmark...');
        return Android.selectBookmark();
    } catch (error) {
        let base = window.localStorage.getItem('baseUrl').split('guide')[0];
        //const redirect = window.location.pathname.split('guide')[0]+"/guide/pages/iosBookmarks/index.html";
        const redirect = base + "/guide/pages/iosBookmarks/index.html";
        window.location.href = redirect;
    }
}

function clearCache() {
    try {
        console.log('clear cache...');
        return Android.clearCache();
    } catch (error) {
        console.warn('clear cache : Android not found, disabling feature...');
    }
}

function replaceMultipleSlashes(item) {
    var i = item.replace(/\/\/+/g, '/')
    console.log(' i is ', i)
    return i;
}

function isBookmarked(url) {
    let paragraphs = document.querySelectorAll('#masterbookmarks p');
    console.log('paragraphs ', paragraphs)
    let result = false;
    for(let i = 0; i < paragraphs.length; i++) {
        let para = paragraphs[i];
        let paraCompare = para.innerHTML.split('www/guide')[1];
        let urlCompare = url.split('www/guide')[1];
        console.log('paraCompare ', paraCompare);
        console.log('urlCompare ', urlCompare);
        if (paraCompare.includes(urlCompare)) {
            result = true;
            break;
        }
    }
    return result;
}

function highlightTab() {
    console.info('highlightTab: ', BOTTOM_MENU);
    console.info('highlightTab: Enter...');
    var p = window.location.pathname;

    /*console.info('highlightTab: Removing slashes...');
    var re = new RegExp("/");
    p = p.replace(re, ""); */

    /* This helps vary the start location based on tb/ or eml/ */
    var start = p.indexOf("/", 2) + 1;
    /* Gets length by removing Start position */
    var length = (p.lastIndexOf("/") - start);
    /* Correct string without adjustments that break when app prefix varies e.g. /tb/ */
    var np = p.substr(start, length);
    console.info('highlightTab: np = ', np);

    if (np == 'mobile') {
        console.info('highlightTab: np = mobile');
        p = p.substr(np.length);
        p = p.replace(/\//g, "");
        np = p;
    } else if (np == 'data') {
        console.info('highlightTab: np = data');
        p = p.substr('/data/user/0/org.jembi.eml/www/guide/'.length - 1);
        p = p.substr(0, p.indexOf("/"));
        p = p.replace(/\//g, "");
        np = p;
    }

    var idx = BOTTOM_MENU.indexOf(np);

    var nav = document.getElementsByClassName("fix-bottom");
    nav = nav[0];

    var tmp = new Array();

    console.info('highlightTab: Stepping through fix-bottom elements...');
    for (var i = 0; i < nav.childNodes.length; i++) {
        if (nav.childNodes[i].className == "navbar-item") {
            tmp.push(nav.childNodes[i]);
        }
    }
    console.info('highlightTab: Looking to toggle bottom-nav-selected...');
    for (var i = 0; i < tmp.length; i++) {
        console.info('highlightTab: idx =', idx);
        console.info('highlightTab: i =', i);
        if (idx === i) {
            console.info('highlightTab: Found index:', idx);
            var item = tmp[i];
            item.classList.toggle('bottom-nav-selected');
        }
    }
}

function initMap(lat, lng) {
    console.log('lat:', lat);
    console.log('lng:', lng);
    if (lat && lng) {
        var location = {lat: lat, lng: lng};
        var map = new google.maps.Map(document.getElementById('map'), {zoom: 14, center: location});
        var marker = new google.maps.Marker({position: location, map: map});
    }
}

function scrollToBottom() {
    window.scrollTo(0, document.body.scrollHeight);
}

$('.burger').click(function () {
    $('.burger').toggleClass('is-active');
    $('#main-navbar').toggleClass('is-active');
});

/*
 * The first function in document.ready is temporary.  It has to look for all existing footnote links, and replace them
 * with a general call to scroll to the bottom of the page.
 *
 * See https://jembiprojects.jira.com/browse/CRD-329
 *
 * Note the permanent fix to to add a HeaderBlock in the CMS with the title "Footnotes", this will automatically add a
 * <h1 id="footnotes">Footnotes</h1> element with a slugified ID.  This ID can then be used to create / update an
 * in page anchor, with the value "#footnotes".
 */
function deleteBookmark(which) {
    let divToAddTo = document.getElementById('bookmarksHere');
    let content = '';
    divToAddTo.innerHTML = content;
    window.ReactNativeWebView.postMessage(JSON.stringify({delete: true, what: which}));
}
$(document).ready(function () {
    window.addEventListener("message", message => {
        if (!window.location.href.includes("favourites/index.html")) {
            console.log('window.location.href')
            let p = window.location.href.split('guide')
            let newUrl = p[0] + 'guide/favourites/index.html'
            window.location.href = newUrl
        }
        let numberOfItems = message.data.length
        let divToAddTo = document.getElementById('bookmarksHere');
        let content = '';
        divToAddTo.innerHTML = content;
        divToAddTo.innerHTML = content;
        for (let i = 0; i < numberOfItems; i++) {
            let item = message.data[i]
            content = content + "<div style='display: flex; width: 100%;'>";
            content = content + "<div style='flex: 3;'><a href='" + item.url + "'>" + item.title + "</a></div>";
            content = content + "<div style='flex: 1;'><span onclick='deleteBookmark(" + item.index + ")';>x</span></div>";
            content = content + "</div>"
        }
        divToAddTo.innerHTML = content;
    }, false);
    const sendDataToReactNativeApp = async (status) => {
        window.ReactNativeWebView.postMessage(JSON.stringify({status: status}));
    };

    console.log('Lookning for a href with footnotes...');
    $('a[href^="#fn"]').each(function (i, obj) {
        $(obj).attr('href', 'javascript:scrollToBottom()');
    });
    if (getMobileOS() === "iOS") {
        if (isBookmarkedIos(window.location.href)) {
            $('.favourite').addClass('is-active');
        }
    } else {
        if (isBookmarked(window.location.href)) {
            $('.favourite').addClass('is-active');
        }
    }

    $('.favourite').on('click', function (e) {
        console.log('document.title, window.location.href ', document.title, window.location.href)
        bookmarkPage(document.title, window.location.href);
        $('.favourite').toggleClass('is-active');
        sendDataToReactNativeApp($('.favourite').hasClass("is-active"));
    });
    $('.modal-link').on('click', function (e) {
        e.preventDefault();
        var el = $(e.target);
        var id = '#' + el.data('target'); // + ' .modal';
        var modal = $(id);
        modal.toggleClass('is-active');
        modal.find('.delete').on('click', function(e) {
            modal.toggleClass('is-active');
        })
    });
    $('.block-modal').prev('.block-paragraph').css('display', 'inline');
    $('.block-modal').next('.block-paragraph').css('display', 'inline');
});

var url_string = window.location.href; //window.location.href
console.log(url_string)
var url = new URL(url_string);
var searchKeyword = url.searchParams.get("q");
console.log(searchKeyword);
// highlight(searchKeyword);

// function highlight(searchKeyword) {
//     var inputText = document.getElementsByClassName("container single");
//     var innerHTML = inputText[0].innerHTML;
//     var index = innerHTML.indexOf(searchKeyword);

//     var regEx = new RegExp(searchKeyword, "ig");
//     innerHTML = innerHTML.replace(regEx, `<span style='background:yellow'>${searchKeyword}</span>`)
//     console.log(innerHTML);
//     inputText[0].innerHTML = innerHTML;

// }

